"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const wallet_entity_1 = require("./wallet.entity");
const typeorm_2 = require("@nestjs/typeorm");
const users_service_1 = require("../users/users.service");
let WalletService = class WalletService {
    walletRepo;
    userProfileService;
    constructor(walletRepo, userProfileService) {
        this.walletRepo = walletRepo;
        this.userProfileService = userProfileService;
    }
    async createWallet(userProfileId) {
        const wallet = await this.walletRepo.findOne({
            where: {
                userProfileId: userProfileId,
            },
            relations: {
                userProfile: true,
            },
        });
        if (wallet) {
            throw new common_1.BadRequestException('wallet is already created');
        }
        const newWallet = this.walletRepo.create({
            balance: 0,
            userProfileId: userProfileId,
        });
        return await this.walletRepo.save(newWallet);
    }
    async getWalletById(id) {
        const wallet = await this.walletRepo.findOne({
            where: {
                id,
            },
            relations: {
                userProfile: true,
            },
        });
        if (!wallet) {
            throw new common_1.NotFoundException('Wallet not found ');
        }
        return wallet;
    }
    async getWalletByUserProfileId(userProfileId) {
        const profile = await this.userProfileService.getUserByProfileId(userProfileId);
        const wallet = await this.walletRepo.findOne({
            where: {
                userProfileId: profile.id,
            },
            relations: {
                userProfile: true,
            },
        });
        if (!wallet) {
            throw new common_1.NotFoundException('Wallet not found ');
        }
        return wallet;
    }
    async getAllWallets() {
        return await this.walletRepo.find();
    }
    async updateWalletBalance(userProfileId, amount) {
        const wallet = await this.getWalletByUserProfileId(userProfileId);
        wallet.balance = amount;
        return await this.walletRepo.save(wallet);
    }
};
exports.WalletService = WalletService;
exports.WalletService = WalletService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(wallet_entity_1.Wallet)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        users_service_1.UsersService])
], WalletService);
//# sourceMappingURL=wallet.service.js.map