import { Repository } from 'typeorm';
import { Wallet } from './wallet.entity';
import { UsersService } from 'src/users/users.service';
export declare class WalletService {
    private readonly walletRepo;
    private readonly userProfileService;
    constructor(walletRepo: Repository<Wallet>, userProfileService: UsersService);
    createWallet(userProfileId: string): Promise<Wallet>;
    getWalletById(id: string): Promise<Wallet>;
    getWalletByUserProfileId(userProfileId: string): Promise<Wallet>;
    getAllWallets(): Promise<Wallet[]>;
    updateWalletBalance(userProfileId: string, amount: number): Promise<Wallet>;
}
