"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletController = void 0;
const common_1 = require("@nestjs/common");
const wallet_service_1 = require("./wallet.service");
const wallet_dto_1 = require("../dtos/wallet.dto");
const swagger_1 = require("@nestjs/swagger");
const index_guards_1 = require("../auth/guards/index.guards");
let WalletController = class WalletController {
    walletService;
    constructor(walletService) {
        this.walletService = walletService;
    }
    async getWalletByUserProfileId(id) {
        if (id.trim() === '' || !id) {
            throw new common_1.BadRequestException('Please provide a valid id');
        }
        const wallet = await this.walletService.getWalletByUserProfileId(id);
        const { userProfile, ...restOfWallet } = wallet;
        return restOfWallet;
    }
};
exports.WalletController = WalletController;
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get wallet details by user profile ID' }),
    (0, swagger_1.ApiQuery)({
        name: 'userProfileId',
        type: String,
        required: true,
        description: 'User profile ID used to fetch wallet details',
    }),
    (0, swagger_1.ApiOkResponse)({
        description: 'Wallet retrieved successfully',
        type: wallet_dto_1.WalletResponseDto,
    }),
    (0, swagger_1.ApiBadRequestResponse)({
        description: 'Invalid or missing userProfileId',
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard),
    (0, common_1.Get)('/balance'),
    __param(0, (0, common_1.Query)('userProfileId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "getWalletByUserProfileId", null);
exports.WalletController = WalletController = __decorate([
    (0, swagger_1.ApiTags)('Wallet'),
    (0, common_1.Controller)('wallet'),
    __metadata("design:paramtypes", [wallet_service_1.WalletService])
], WalletController);
//# sourceMappingURL=wallet.controller.js.map