"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const user_entity_1 = require("./user.entity");
const typeorm_2 = require("@nestjs/typeorm");
const roles_service_1 = require("../roles/roles.service");
const roles_entity_1 = require("../roles/roles.entity");
const bcrypt = __importStar(require("bcrypt"));
const userProfile_entity_1 = require("./userProfile.entity");
const index_methods_1 = require("../common/methods/index.methods");
const nanoid_1 = require("nanoid");
let UsersService = class UsersService {
    userRepo;
    roleService;
    userProfileRepo;
    constructor(userRepo, roleService, userProfileRepo) {
        this.userRepo = userRepo;
        this.roleService = roleService;
        this.userProfileRepo = userProfileRepo;
    }
    async createUser(username, password) {
        const getUser = await this.userRepo.findOne({
            where: {
                username,
            },
        });
        if (getUser) {
            throw new common_1.BadRequestException('User already exists');
        }
        const referalCode = (0, nanoid_1.nanoid)(12);
        const role = await this.roleService.getRoleByName(roles_entity_1.RolesEnum.USER);
        const hashedPassword = await bcrypt.hash(password, 10);
        const newUser = this.userRepo.create({
            username: username,
            password: hashedPassword,
            roles: [role],
            referralCode: referalCode,
        });
        const savedUser = await this.userRepo.save(newUser);
        return await this.getUserById(savedUser.id);
    }
    async createUserWithProfile(userInfo) {
        const referredByUser = await this.userRepo.findOne({
            where: {
                referralCode: userInfo.referredByCode,
            },
            relations: {
                profile: true,
            },
        });
        if (!referredByUser) {
            throw new common_1.BadRequestException('Please use a valid Referral code');
        }
        const phoneNumber = (0, index_methods_1.formatPhoneNumber)(userInfo.phone_number);
        const isNumberTaken = await this.userProfileRepo.findAndCount({
            where: {
                phone_number: phoneNumber,
            },
        });
        console.log;
        if (isNumberTaken[1] > 0) {
            throw new common_1.BadRequestException('Phone number already in use');
        }
        const user = await this.createUser(userInfo.email, userInfo.password);
        const userProfile = this.userProfileRepo.create({
            firstName: userInfo.firstName,
            lastName: userInfo.lastName,
            email: userInfo.email,
            phone_number: userInfo.phone_number,
            date_of_birth: userInfo.date_of_birth,
            referredBy: referredByUser.profile,
            user: user,
        });
        await this.userProfileRepo.save(userProfile);
        return await this.getUserById(user.id);
    }
    async getUserByUsername(username) {
        const user = await this.userRepo.findOne({
            where: {
                username,
            },
            relations: {
                profile: true,
                roles: true,
            },
        });
        if (!user) {
            throw new common_1.NotFoundException('user not found');
        }
        return user;
    }
    async getUserById(userId) {
        const user = await this.userRepo.findOne({
            where: {
                id: userId,
            },
            relations: {
                profile: {
                    referrals: true,
                    referredBy: true,
                },
                roles: true,
            },
        });
        if (!user) {
            throw new common_1.BadRequestException('User not found');
        }
        return user;
    }
    async getUserByProfileId(profileId) {
        const user = await this.userProfileRepo.findOne({
            where: {
                id: profileId,
            },
            relations: {
                referrals: true,
                referredBy: true,
            },
        });
        if (!user) {
            throw new common_1.BadRequestException('User not found');
        }
        return user;
    }
    async getAllUsers() {
        const users = await this.userRepo.find({
            relations: {
                roles: true,
                profile: {
                    referredBy: true,
                    referrals: true,
                },
            },
        });
        return users;
    }
    async updateUserProfile(userInfo, userId) {
        const user = await this.getUserById(userId);
        if (!user.profile) {
            throw new common_1.BadRequestException('User profile not found');
        }
        const profile = user.profile;
        if (userInfo.email !== undefined) {
            user.username = userInfo.email;
            profile.email = userInfo.email;
        }
        if (userInfo.firstName !== undefined) {
            profile.firstName = userInfo.firstName;
        }
        if (userInfo.lastName !== undefined) {
            profile.lastName = userInfo.lastName;
        }
        if (userInfo.phone_number !== undefined) {
            profile.phone_number = userInfo.phone_number;
        }
        if (userInfo.date_of_birth !== undefined) {
            profile.date_of_birth = userInfo.date_of_birth;
        }
        await this.userRepo.save(user);
        return await this.userProfileRepo.save(profile);
    }
    async updatePassword(password, userId) {
        const user = await this.getUserById(userId);
        const hashedPassword = await bcrypt.hash(password, 10);
        user.password = hashedPassword;
        await this.userRepo.save(user);
        return;
    }
    async setIsSubscribed(userProfileId) {
        const user = await this.userProfileRepo.findOne({
            where: {
                id: userProfileId,
            },
            relations: {
                allTransactions: true,
            },
        });
        if (!user) {
            throw new common_1.NotFoundException('user not found');
        }
    }
    async getNumberOfReferals(userProfileId) {
        const user = await this.getUserByProfileId(userProfileId);
        return user.referrals.length;
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(user_entity_1.Users)),
    __param(2, (0, typeorm_2.InjectRepository)(userProfile_entity_1.UserProfile)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        roles_service_1.RolesService,
        typeorm_1.Repository])
], UsersService);
//# sourceMappingURL=users.service.js.map