import { Repository } from 'typeorm';
import { Users } from './user.entity';
import { RolesService } from 'src/roles/roles.service';
import { UserProfile } from './userProfile.entity';
import { ICreateUserInterface, IUpdateUserProfileInterface } from 'src/common/interfaces/IUserInterface';
export declare class UsersService {
    private readonly userRepo;
    private roleService;
    private readonly userProfileRepo;
    constructor(userRepo: Repository<Users>, roleService: RolesService, userProfileRepo: Repository<UserProfile>);
    createUser(username: string, password: string): Promise<Users>;
    createUserWithProfile(userInfo: ICreateUserInterface): Promise<Users>;
    getUserByUsername(username: string): Promise<Users>;
    getUserById(userId: string): Promise<Users>;
    getUserByProfileId(profileId: string): Promise<UserProfile>;
    getAllUsers(): Promise<Users[]>;
    updateUserProfile(userInfo: IUpdateUserProfileInterface, userId: string): Promise<UserProfile>;
    updatePassword(password: string, userId: string): Promise<void>;
    setIsSubscribed(userProfileId: string): Promise<void>;
    getNumberOfReferals(userProfileId: string): Promise<number>;
}
