"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const users_service_1 = require("./users.service");
const auth_dto_1 = require("../dtos/auth.dto");
const index_guards_1 = require("../auth/guards/index.guards");
const roles_guards_1 = require("../auth/guards/roles.guards");
const roles_decorator_1 = require("../common/decorators/roles.decorator");
const roles_entity_1 = require("../roles/roles.entity");
let UsersController = class UsersController {
    userServices;
    constructor(userServices) {
        this.userServices = userServices;
    }
    async getAllUsers() {
        return await this.userServices.getAllUsers();
    }
    async getUserById(id) {
        if (!id || id.trim() === '') {
            throw new common_1.BadRequestException('Please provide a valid id');
        }
        const user = await this.userServices.getUserById(id);
        const { password, ...restUser } = user;
        return restUser;
    }
    async getNumberOfReferals(userProfileId) {
        if (userProfileId.trim() === '' || !userProfileId) {
            throw new common_1.BadRequestException('Please provide a valid id');
        }
        const no = await this.userServices.getNumberOfReferals(userProfileId);
        return {
            totalReferals: no,
        };
    }
};
exports.UsersController = UsersController;
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get all users' }),
    (0, swagger_1.ApiOkResponse)({
        description: 'List of users returned successfully',
        type: [auth_dto_1.UserReponseDto],
    }),
    (0, common_1.Get)('all'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "getAllUsers", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get user by ID' }),
    (0, swagger_1.ApiQuery)({
        name: 'id',
        type: String,
        required: true,
        description: 'User ID',
    }),
    (0, swagger_1.ApiOkResponse)({
        description: 'User returned successfully',
        type: auth_dto_1.UserReponseDto,
    }),
    (0, swagger_1.ApiBadRequestResponse)({ description: 'Invalid or missing user id' }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "getUserById", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get total number of referrals for a user profile' }),
    (0, swagger_1.ApiQuery)({
        name: 'userProfileId',
        type: String,
        required: true,
        description: 'User Profile ID used to count total referrals',
    }),
    (0, swagger_1.ApiOkResponse)({
        description: 'Total number of referrals returned successfully',
        schema: {
            example: {
                totalReferals: 5,
            },
        },
    }),
    (0, swagger_1.ApiBadRequestResponse)({
        description: 'Invalid or missing userProfileId',
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard),
    (0, common_1.Get)('/totalReferals'),
    __param(0, (0, common_1.Query)('userProfileId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "getNumberOfReferals", null);
exports.UsersController = UsersController = __decorate([
    (0, swagger_1.ApiTags)('Users'),
    (0, common_1.Controller)('users'),
    __metadata("design:paramtypes", [users_service_1.UsersService])
], UsersController);
//# sourceMappingURL=users.controller.js.map