"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const transactions_entity_1 = require("./transactions.entity");
const typeorm_2 = require("typeorm");
const userProfile_entity_1 = require("../users/userProfile.entity");
const mpesa_service_1 = require("../mpesa/mpesa.service");
const transaction_config_service_1 = require("../transaction-config/transaction-config.service");
const transactionConfig_entity_1 = require("../transaction-config/transactionConfig.entity");
const ioredis_1 = __importDefault(require("ioredis"));
const redis_service_1 = require("../redis/redis.service");
const index_methods_1 = require("../common/methods/index.methods");
const wallet_service_1 = require("../wallet/wallet.service");
let TransactionsService = class TransactionsService {
    transactionRepo;
    userRepo;
    mpesaService;
    txconfigService;
    redisClient;
    redisService;
    walletService;
    constructor(transactionRepo, userRepo, mpesaService, txconfigService, redisClient, redisService, walletService) {
        this.transactionRepo = transactionRepo;
        this.userRepo = userRepo;
        this.mpesaService = mpesaService;
        this.txconfigService = txconfigService;
        this.redisClient = redisClient;
        this.redisService = redisService;
        this.walletService = walletService;
    }
    async initiateSubscription(userProfileId, phone_number) {
        const user = await this.userRepo.findOne({
            where: {
                id: userProfileId,
            },
        });
        if (!user) {
            throw new common_1.BadRequestException('User not found');
        }
        if (user.isSubscribed) {
            throw new common_1.BadRequestException('User already subscribed');
        }
        const subscriptionCost = await this.txconfigService.findTxtByName(transactionConfig_entity_1.ETransactionConfigEnum.SUBSCRIPTION_COST);
        const phoneNumber = (0, index_methods_1.formatPhoneNumber)(phone_number);
        const resp = await this.mpesaService.sendStkPush(phoneNumber, subscriptionCost.amount);
        const toRedis = {
            mpesaTxId: resp.CheckoutRequestID,
            amount: subscriptionCost.amount,
            status: 'pending',
            message: '',
            userProfileId: user.id,
            phone: phoneNumber,
            referrerId: user.referrerId,
        };
        await this.redisService.set(resp.CheckoutRequestID, JSON.stringify(toRedis), 120000);
        return new Promise(async (resolve, reject) => {
            const timer = setTimeout(() => {
                reject(new common_1.BadRequestException('Payment callback did not arrive in time'));
            }, 60000);
            const subscriber = this.redisClient.duplicate();
            await subscriber.subscribe('mpesa');
            subscriber.on('message', async (channel, message) => {
                const data = JSON.parse(message);
                if (data.mpesaTxId === resp.CheckoutRequestID) {
                    clearTimeout(timer);
                    if (data.status === 'failed') {
                        subscriber.unsubscribe();
                        subscriber.quit();
                        reject(new common_1.BadRequestException(data.message));
                        return;
                    }
                    resolve({ message: 'Payment successful' });
                    subscriber.unsubscribe();
                    subscriber.quit();
                }
            });
        });
    }
    async requestMpesaBalance() {
        const initiateBalacnce = await this.mpesaService.checkBalance();
        const toRedis = {
            mpesaTxId: initiateBalacnce.ConversationID,
            status: 'pending',
            message: '',
        };
        await this.redisService.set(initiateBalacnce.ConversationID, JSON.stringify(toRedis), 120000);
        return new Promise(async (resolve, reject) => {
            const timer = setTimeout(() => { }, 60000);
            const subscriber = this.redisClient.duplicate();
            await subscriber.subscribe('mpesa');
            subscriber.on('message', (channel, message) => {
                const data = JSON.parse(message);
                if (data.mpesaTxId === initiateBalacnce.ConversationID) {
                    clearTimeout(timer);
                    if (data.status === 'failed') {
                        subscriber.unsubscribe();
                        subscriber.quit();
                        console.error('balance error:', data.message);
                        reject(new common_1.InternalServerErrorException('some thing went wrong, please try again later'));
                        return;
                    }
                    const acc = data.balance?.split('&').map((item) => {
                        const [name, currency, ledgerBalance, availableBalance, reserved1, reserved2,] = item.split('|');
                        return {
                            name,
                            currency,
                            ledgerBalance,
                            availableBalance,
                            reserved1,
                            reserved2,
                        };
                    });
                    resolve(acc);
                    subscriber.unsubscribe();
                    subscriber.quit();
                }
            });
        });
    }
    async intiateWithdrawal(amount, phone_number, userProfileId) {
        const phoneNumber = (0, index_methods_1.formatPhoneNumber)(phone_number);
        const user = await this.userRepo.findOne({
            where: {
                id: userProfileId,
            },
            relations: {
                wallet: true,
                user: true,
            },
        });
        if (!user) {
            throw new common_1.BadRequestException('User with the ID not found');
        }
        if (!user.wallet || !user.isSubscribed) {
            throw new common_1.BadRequestException('User is not yet subscribed');
        }
        const minimumWithdrawal = await this.txconfigService.findTxtByName(transactionConfig_entity_1.ETransactionConfigEnum.MINIMUM_WALLET_WITHRAWAL);
        if (user.wallet.balance < minimumWithdrawal.amount) {
            throw new common_1.BadRequestException('Your balance is below the minimum amount to be withdrawn');
        }
        if (user.wallet.balance < amount) {
            throw new common_1.BadRequestException('Insufficient balance');
        }
        const mainBalance = await this.requestMpesaBalance();
        if (!mainBalance) {
            console.log('issue with balance enquiry');
            throw new common_1.InternalServerErrorException('Some thing went wrong');
        }
        const bal = mainBalance.find((item) => item.name === 'Utility Account')
            .availableBalance;
        if (Number(bal) < amount) {
            console.log('issue with balance enquiry', 'insufficient balance');
            throw new common_1.BadRequestException('Some thing went wrong. Try again later');
        }
        const withdrawRes = await this.mpesaService.withdraw(amount, phoneNumber);
        const toRedis = {
            mpesaTxID: withdrawRes.OriginatorConversationID,
            status: 'pending',
            message: '',
            userProfileId: user.id,
            amount: amount,
            phone: phoneNumber,
            mpesaId: '',
        };
        await this.redisService.set(withdrawRes.OriginatorConversationID, JSON.stringify(toRedis), 120000);
        return new Promise(async (resolve, reject) => {
            const timer = setTimeout(() => {
                reject(new common_1.InternalServerErrorException('Payment callback did not arrive in time'));
            }, 60000);
            const subscriber = this.redisClient.duplicate();
            await subscriber.subscribe('mpesa');
            subscriber.on('message', async (channel, message) => {
                const data = JSON.parse(message);
                if (data.mpesaTxID === withdrawRes.OriginatorConversationID) {
                    clearTimeout(timer);
                    if (data.status === 'failed') {
                        reject(new common_1.BadRequestException(data.message));
                        subscriber.unsubscribe();
                        subscriber.quit();
                        return;
                    }
                    const bal = user.wallet.balance - amount;
                    await this.walletService.updateWalletBalance(userProfileId, bal);
                    const res = this.transactionRepo.create({
                        mpesaTransactionId: data.mpesaId,
                        amount: amount,
                        phone_number: phoneNumber,
                        transaction_type: transactions_entity_1.ETransactionType.COMMISSION,
                        userProfileId: user.id,
                    });
                    await this.transactionRepo.save(res);
                    await this.redisService.del(withdrawRes.OriginatorConversationID);
                    resolve({ message: 'success' });
                    subscriber.unsubscribe();
                    subscriber.quit();
                    resolve({ message: 'Payment successful' });
                }
            });
        });
    }
    async handleMpesaBalanceCallback(data) {
        const fromRedisString = await this.redisService.get(data.Result.ConversationID);
        if (!fromRedisString)
            return;
        const fromRedis = JSON.parse(fromRedisString);
        if (fromRedis.mpesaTxId === data.Result.ConversationID) {
            if (data.Result.ResultCode !== 0) {
                fromRedis.status = 'failed';
                fromRedis.message = data.Result.ResultDesc;
                await this.redisClient.publish('mpesa', JSON.stringify(fromRedis));
                return;
            }
            fromRedis.status = 'success';
            fromRedis.message = 'success';
            fromRedis.balance = data.Result.ResultParameters?.ResultParameter.find((val) => val.Key === 'AccountBalance')?.Value.toString();
            await this.redisClient.publish('mpesa', JSON.stringify(fromRedis));
            return;
        }
        return;
    }
    async handleMpesaWithdrawalCallback(data) {
        const fromRedisString = await this.redisService.get(data.Result.OriginatorConversationID);
        if (!fromRedisString)
            return;
        const fromRedis = JSON.parse(fromRedisString);
        if (data.Result.OriginatorConversationID === fromRedis.mpesaTxID) {
            if (data.Result.ResultCode !== 0) {
                fromRedis.status = 'failed';
                fromRedis.message = data.Result.ResultDesc;
                this.redisClient.publish('mpesa', JSON.stringify(fromRedis));
                return;
            }
            fromRedis.status = 'success';
            fromRedis.message = data.Result.ResultDesc;
            fromRedis.mpesaId = data.Result.TransactionID;
            await this.redisClient.publish('mpesa', JSON.stringify(fromRedis));
            return;
        }
    }
    async saveSubscriptionTransaction(subData) {
        console.log('call back response', subData);
        const fromRedisString = await this.redisService.get(subData.Body.stkCallback.CheckoutRequestID);
        if (!fromRedisString)
            return;
        const fromRedis = JSON.parse(fromRedisString);
        if (subData.Body.stkCallback.ResultCode !== 0 &&
            fromRedis.mpesaTxId === subData.Body.stkCallback.CheckoutRequestID) {
            fromRedis.status = 'failed';
            fromRedis.message = subData.Body.stkCallback.ResultDesc;
            await this.redisClient.publish('mpesa', JSON.stringify(fromRedis));
            return;
        }
        if (fromRedis.mpesaTxId === subData.Body.stkCallback.CheckoutRequestID) {
            fromRedis.status = 'success';
            fromRedis.message = subData.Body.stkCallback.ResultDesc;
            await this.redisClient.publish('mpesa', JSON.stringify(fromRedis));
            const [user, referredBy] = await Promise.all([
                this.userRepo.findOne({
                    where: {
                        id: fromRedis.userProfileId,
                    },
                    relations: {
                        user: true,
                    },
                }),
                this.userRepo.findOne({
                    where: {
                        id: fromRedis.referrerId,
                    },
                    relations: {
                        wallet: true,
                    },
                }),
            ]);
            if (!user) {
                console.error('transaction:', 'user not found!');
                return;
            }
            user.isSubscribed = true;
            await this.userRepo.save(user);
            if (referredBy) {
                const commission = (await this.txconfigService.findTxtByName(transactionConfig_entity_1.ETransactionConfigEnum.REFERAL_COMMISSION)) ?? 0;
                if (referredBy.wallet) {
                    referredBy.wallet.balance =
                        referredBy.wallet.balance + commission.amount;
                    await this.userRepo.save(referredBy);
                }
                else {
                    await this.walletService.createWallet(referredBy.id);
                    await this.walletService.updateWalletBalance(referredBy.id, commission.amount);
                }
            }
            const mpesaTransactionId = subData.Body.stkCallback.CallbackMetadata.Item.find((item) => item.Name === 'MpesaReceiptNumber').Value.toString();
            const newTransaction = this.transactionRepo.create({
                mpesaTransactionId: mpesaTransactionId,
                amount: fromRedis.amount,
                phone_number: fromRedis.phone,
                transaction_type: transactions_entity_1.ETransactionType.SUBSCRIPTION,
                userProfileId: user.id,
            });
            await this.transactionRepo.save(newTransaction);
            return;
        }
        return;
    }
    async saveTransaction(userProfileId, amount, mpesa_transaction_id, phone_number, transaction_type) { }
    async getTransactionById(id) {
        const getTransaction = await this.transactionRepo.findOne({
            where: {
                id,
            },
            relations: {
                userProfile: true,
            },
        });
        if (!getTransaction) {
            throw new common_1.BadRequestException('Transaction not found');
        }
        return getTransaction;
    }
    async getAllTransactionByUserProfileId(userProfileId) {
        const transaction = await this.transactionRepo.find({
            relations: { userProfile: true },
            where: {
                userProfileId: userProfileId,
            },
        });
        return transaction;
    }
    async getTransactionByMpesaTransactionId(mpesaTransactionId) {
        const transaction = await this.transactionRepo.findOne({
            where: {
                mpesaTransactionId: mpesaTransactionId,
            },
        });
        if (!transaction) {
            throw new common_1.NotFoundException('Transaction not found');
        }
        return transaction;
    }
    async getAllTransactions() {
        const transactions = await this.transactionRepo.find({
            relations: {
                userProfile: true,
            },
        });
        return transactions;
    }
    async getAllSubscriptionTransactions() {
        return await this.transactionRepo.find({
            where: {
                transaction_type: transactions_entity_1.ETransactionType.SUBSCRIPTION,
            },
            relations: {
                userProfile: true,
            },
        });
    }
    async getAllCommissionTransactions() {
        return await this.transactionRepo.find({
            where: {
                transaction_type: transactions_entity_1.ETransactionType.COMMISSION,
            },
            relations: {
                userProfile: true,
            },
        });
    }
};
exports.TransactionsService = TransactionsService;
exports.TransactionsService = TransactionsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(transactions_entity_1.Transaction)),
    __param(1, (0, typeorm_1.InjectRepository)(userProfile_entity_1.UserProfile)),
    __param(4, (0, common_1.Inject)('REDIS_CLIENT')),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        mpesa_service_1.MpesaService,
        transaction_config_service_1.TransactionConfigService,
        ioredis_1.default,
        redis_service_1.RedisService,
        wallet_service_1.WalletService])
], TransactionsService);
//# sourceMappingURL=transactions.service.js.map