import { ETransactionType, Transaction } from './transactions.entity';
import { Repository } from 'typeorm';
import { UserProfile } from 'src/users/userProfile.entity';
import { MpesaService } from 'src/mpesa/mpesa.service';
import { TransactionConfigService } from 'src/transaction-config/transaction-config.service';
import Redis from 'ioredis';
import { RedisService } from 'src/redis/redis.service';
import { IMpesaAccountBalanceCallback, IMpesaSTKCallback, MpesaB2CCallbackResult } from 'src/dtos/mpesa.dto';
import { WalletService } from 'src/wallet/wallet.service';
export declare class TransactionsService {
    private readonly transactionRepo;
    private readonly userRepo;
    private readonly mpesaService;
    private readonly txconfigService;
    private readonly redisClient;
    private readonly redisService;
    private readonly walletService;
    constructor(transactionRepo: Repository<Transaction>, userRepo: Repository<UserProfile>, mpesaService: MpesaService, txconfigService: TransactionConfigService, redisClient: Redis, redisService: RedisService, walletService: WalletService);
    initiateSubscription(userProfileId: string, phone_number: string): Promise<unknown>;
    requestMpesaBalance(): Promise<{
        name: string;
        currency: string;
        ledgerBalance: string;
        availableBalance: string;
        reserved1: string;
        reserved2: string;
    }[] | undefined>;
    intiateWithdrawal(amount: number, phone_number: string, userProfileId: string): Promise<unknown>;
    handleMpesaBalanceCallback(data: IMpesaAccountBalanceCallback): Promise<void>;
    handleMpesaWithdrawalCallback(data: MpesaB2CCallbackResult): Promise<void>;
    saveSubscriptionTransaction(subData: IMpesaSTKCallback): Promise<void>;
    saveTransaction(userProfileId: number, amount: number, mpesa_transaction_id: string, phone_number: string, transaction_type: ETransactionType): Promise<void>;
    getTransactionById(id: string): Promise<Transaction>;
    getAllTransactionByUserProfileId(userProfileId: string): Promise<Transaction[]>;
    getTransactionByMpesaTransactionId(mpesaTransactionId: string): Promise<Transaction>;
    getAllTransactions(): Promise<Transaction[]>;
    getAllSubscriptionTransactions(): Promise<Transaction[]>;
    getAllCommissionTransactions(): Promise<Transaction[]>;
}
