"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionsController = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("axios");
const transactions_dto_1 = require("../dtos/transactions.dto");
const transactions_service_1 = require("./transactions.service");
const swagger_1 = require("@nestjs/swagger");
const index_guards_1 = require("../auth/guards/index.guards");
const roles_guards_1 = require("../auth/guards/roles.guards");
const roles_entity_1 = require("../roles/roles.entity");
const roles_decorator_1 = require("../common/decorators/roles.decorator");
let TransactionsController = class TransactionsController {
    transactionService;
    constructor(transactionService) {
        this.transactionService = transactionService;
    }
    async getStkCallback(req) {
        await this.transactionService.saveSubscriptionTransaction(req);
        return { message: 'success' };
    }
    async getWdCallback(req) {
        await this.transactionService.handleMpesaWithdrawalCallback(req);
        return { message: 'success' };
    }
    async getMpesaBalance() {
        return await this.transactionService.requestMpesaBalance();
    }
    async getBalanceCallback(body) {
        await this.transactionService.handleMpesaBalanceCallback(body);
        return { message: 'success' };
    }
    async subscribe(body) {
        return await this.transactionService.initiateSubscription(body.userProfileId, body.phoneNumber);
    }
    async withdraw(body) {
        return this.transactionService.intiateWithdrawal(body.amount, body.phoneNumber, body.userProfileId);
    }
};
exports.TransactionsController = TransactionsController;
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'M-Pesa STK Callback Webhook' }),
    (0, common_1.Post)('/stk/callback'),
    (0, common_1.HttpCode)(axios_1.HttpStatusCode.Ok),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], TransactionsController.prototype, "getStkCallback", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'M-Pesa STK Callback Webhook' }),
    (0, common_1.Post)('/wd/callback'),
    (0, common_1.HttpCode)(axios_1.HttpStatusCode.Ok),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], TransactionsController.prototype, "getWdCallback", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get Mpesa Balance' }),
    (0, common_1.Get)('/mpesa/balance'),
    (0, common_1.HttpCode)(axios_1.HttpStatusCode.Ok),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TransactionsController.prototype, "getMpesaBalance", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'M-Pesa Balance Callback Webhook' }),
    (0, common_1.Post)('/bal/callback'),
    (0, common_1.HttpCode)(axios_1.HttpStatusCode.Ok),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], TransactionsController.prototype, "getBalanceCallback", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Initiate subscription via STK Push' }),
    (0, swagger_1.ApiBody)({ type: transactions_dto_1.CreateTransactionDto }),
    (0, common_1.Post)('/subscribe'),
    (0, common_1.HttpCode)(axios_1.HttpStatusCode.Ok),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [transactions_dto_1.CreateTransactionDto]),
    __metadata("design:returntype", Promise)
], TransactionsController.prototype, "subscribe", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Initiate commission Withdrawal via B2C' }),
    (0, swagger_1.ApiBody)({ type: transactions_dto_1.CreateWithdrawalDto }),
    (0, common_1.Post)('/withdraw'),
    (0, common_1.HttpCode)(axios_1.HttpStatusCode.Ok),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [transactions_dto_1.CreateWithdrawalDto]),
    __metadata("design:returntype", Promise)
], TransactionsController.prototype, "withdraw", null);
exports.TransactionsController = TransactionsController = __decorate([
    (0, swagger_1.ApiTags)('Transactions'),
    (0, common_1.Controller)('transactions'),
    __metadata("design:paramtypes", [transactions_service_1.TransactionsService])
], TransactionsController);
//# sourceMappingURL=transactions.controller.js.map