import type { IMpesaAccountBalanceCallback, IMpesaSTKCallback, MpesaB2CCallbackResult } from 'src/dtos/mpesa.dto';
import { CreateTransactionDto, CreateWithdrawalDto } from 'src/dtos/transactions.dto';
import { TransactionsService } from './transactions.service';
export declare class TransactionsController {
    private readonly transactionService;
    constructor(transactionService: TransactionsService);
    getStkCallback(req: IMpesaSTKCallback): Promise<{
        message: string;
    }>;
    getWdCallback(req: MpesaB2CCallbackResult): Promise<{
        message: string;
    }>;
    getMpesaBalance(): Promise<{
        name: string;
        currency: string;
        ledgerBalance: string;
        availableBalance: string;
        reserved1: string;
        reserved2: string;
    }[] | undefined>;
    getBalanceCallback(body: IMpesaAccountBalanceCallback): Promise<{
        message: string;
    }>;
    subscribe(body: CreateTransactionDto): Promise<unknown>;
    withdraw(body: CreateWithdrawalDto): Promise<unknown>;
}
