import { ETransactionConfigEnum, TransactionConfig } from './transactionConfig.entity';
import { Repository } from 'typeorm';
export declare class TransactionConfigService {
    private readonly transactionConfigRepo;
    constructor(transactionConfigRepo: Repository<TransactionConfig>);
    createTxConfig(configName: ETransactionConfigEnum, amount: number): Promise<TransactionConfig>;
    createSubscriptionConfig(amount: number): Promise<TransactionConfig>;
    createReferalCommissionConfig(amount: number): Promise<TransactionConfig>;
    createMinimumWalletConfig(amount: number): Promise<TransactionConfig>;
    findTxById(id: string): Promise<TransactionConfig>;
    findTxtByName(name: ETransactionConfigEnum): Promise<TransactionConfig>;
    getMinimumWithDrawalAmount(): Promise<TransactionConfig>;
    findAllTx(): Promise<TransactionConfig[]>;
    updateTxConfigAmount(id: string, amount: number): Promise<TransactionConfig>;
    updateSubscriptionAmount(amount: number): Promise<TransactionConfig>;
    updateReferalCommissionAmount(amount: number): Promise<TransactionConfig>;
    updateMinimumWalletAmount(amount: number): Promise<TransactionConfig>;
}
