"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionConfigController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const transaction_config_service_1 = require("./transaction-config.service");
const txConfig_dto_1 = require("../dtos/txConfig.dto");
const index_guards_1 = require("../auth/guards/index.guards");
const roles_guards_1 = require("../auth/guards/roles.guards");
const roles_decorator_1 = require("../common/decorators/roles.decorator");
const roles_entity_1 = require("../roles/roles.entity");
let TransactionConfigController = class TransactionConfigController {
    txService;
    constructor(txService) {
        this.txService = txService;
    }
    async getAllTxConfig() {
        return await this.txService.findAllTx();
    }
    async getTxConfigById(id) {
        return await this.txService.findTxById(id);
    }
    async updateTxSubConfigAmount(body) {
        return await this.txService.updateSubscriptionAmount(body.amount);
    }
    async updateTxWalletConfigAmount(body) {
        return await this.txService.updateMinimumWalletAmount(body.amount);
    }
    async updateTxCommissionConfigAmount(body) {
        return await this.txService.updateReferalCommissionAmount(body.amount);
    }
    async getMinimumWalletAMount() {
        return await this.txService.getMinimumWithDrawalAmount();
    }
};
exports.TransactionConfigController = TransactionConfigController;
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all transaction configuration settings' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        type: txConfig_dto_1.TxConfigResponseDto,
        isArray: true,
        description: 'List of transaction configurations',
    }),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)('all'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TransactionConfigController.prototype, "getAllTxConfig", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve a transaction configuration by its ID' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        type: txConfig_dto_1.TxConfigResponseDto,
        description: 'transaction configuration',
    }),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)('configId'),
    __param(0, (0, common_1.Query)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TransactionConfigController.prototype, "getTxConfigById", null);
__decorate([
    (0, swagger_1.ApiOperation)({
        summary: 'Update the subscription amount in the transaction configuration',
    }),
    (0, swagger_1.ApiBody)({
        type: txConfig_dto_1.TxConfigRequestDto,
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        type: txConfig_dto_1.TxConfigResponseDto,
        description: 'transaction configuration',
    }),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    (0, common_1.HttpCode)(200),
    (0, common_1.Patch)('update/subscriptionAmount'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [txConfig_dto_1.TxConfigRequestDto]),
    __metadata("design:returntype", Promise)
], TransactionConfigController.prototype, "updateTxSubConfigAmount", null);
__decorate([
    (0, swagger_1.ApiOperation)({
        summary: 'Update the minimum wallet amount in the transaction configuration',
    }),
    (0, swagger_1.ApiBody)({
        type: txConfig_dto_1.TxConfigRequestDto,
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        type: txConfig_dto_1.TxConfigResponseDto,
        description: 'transaction configuration',
    }),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    (0, common_1.HttpCode)(200),
    (0, common_1.Patch)('update/minimumWalletAmont'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [txConfig_dto_1.TxConfigRequestDto]),
    __metadata("design:returntype", Promise)
], TransactionConfigController.prototype, "updateTxWalletConfigAmount", null);
__decorate([
    (0, swagger_1.ApiOperation)({
        summary: 'Update the referral commission amount in the transaction configuration',
    }),
    (0, swagger_1.ApiBody)({
        type: txConfig_dto_1.TxConfigRequestDto,
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        type: txConfig_dto_1.TxConfigResponseDto,
        description: 'transaction configuration',
    }),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    (0, common_1.HttpCode)(200),
    (0, common_1.Patch)('update/commissionAmount'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [txConfig_dto_1.TxConfigRequestDto]),
    __metadata("design:returntype", Promise)
], TransactionConfigController.prototype, "updateTxCommissionConfigAmount", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve the minimum wallet amount' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        type: txConfig_dto_1.TxConfigResponseDto,
        description: 'transaction configuration',
    }),
    (0, common_1.HttpCode)(200),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.USER),
    (0, common_1.Get)('/minimumWalletAmount'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TransactionConfigController.prototype, "getMinimumWalletAMount", null);
exports.TransactionConfigController = TransactionConfigController = __decorate([
    (0, common_1.Controller)('transaction-config'),
    (0, swagger_1.ApiTags)('Transaction Configurations'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [transaction_config_service_1.TransactionConfigService])
], TransactionConfigController);
//# sourceMappingURL=transaction-config.controller.js.map