"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var SeederService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeederService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const roles_entity_1 = require("../roles/roles.entity");
const transactionConfig_entity_1 = require("../transaction-config/transactionConfig.entity");
const user_entity_1 = require("../users/user.entity");
const typeorm_2 = require("typeorm");
const bcypt = __importStar(require("bcrypt"));
const nanoid_1 = require("nanoid");
const userProfile_entity_1 = require("../users/userProfile.entity");
let SeederService = SeederService_1 = class SeederService {
    usersRepo;
    profileRepo;
    roleRepo;
    transactionConfigRepo;
    logger = new common_1.Logger(SeederService_1.name);
    constructor(usersRepo, profileRepo, roleRepo, transactionConfigRepo) {
        this.usersRepo = usersRepo;
        this.profileRepo = profileRepo;
        this.roleRepo = roleRepo;
        this.transactionConfigRepo = transactionConfigRepo;
    }
    async seed() {
        this.logger.log('Starting database seeding...');
        await this.seedAll();
        this.logger.log('Database seeding complete!');
    }
    async seedAll() {
        await this.seedRoles();
        await this.seedAdminUser();
        await this.seedTxConfig();
    }
    async seedRoles() {
        const adminRole = await this.roleRepo.findOne({
            where: {
                name: roles_entity_1.RolesEnum.ADMIN,
            },
        });
        const userRole = await this.roleRepo.findOne({
            where: {
                name: roles_entity_1.RolesEnum.USER,
            },
        });
        if (!adminRole) {
            const newAdminRole = this.roleRepo.create({
                name: roles_entity_1.RolesEnum.ADMIN,
            });
            await this.roleRepo.save(newAdminRole);
            this.logger.log('ADMIN role created successfully');
        }
        if (!userRole) {
            const newUserRole = this.roleRepo.create({
                name: roles_entity_1.RolesEnum.USER,
            });
            await this.roleRepo.save(newUserRole);
        }
        return;
    }
    async seedAdminUser() {
        const admin = await this.usersRepo.findOne({
            where: {
                username: 'Admin',
            },
        });
        const AdminRole = await this.roleRepo.findOne({
            where: {
                name: roles_entity_1.RolesEnum.ADMIN,
            },
        });
        if (!AdminRole) {
            this.logger.log('Admin role is not found');
            return;
        }
        if (!admin) {
            const password = process.env.ADMIN_PASSWORD;
            const hashedPassword = await bcypt.hash(password, 10);
            const referralCode = (0, nanoid_1.nanoid)(12);
            const email = 'techguymoi@gmail.com';
            const newAdmin = this.usersRepo.create({
                username: email,
                password: hashedPassword,
                referralCode: referralCode,
                roles: [AdminRole],
            });
            const newAdminProfile = this.profileRepo.create({
                firstName: 'tech',
                lastName: 'guy',
                email: email,
                date_of_birth: new Date('1997-1-1'),
                phone_number: '254715691186',
                isSubscribed: true
            });
            newAdmin.profile = newAdminProfile;
            await this.usersRepo.save(newAdmin);
            this.logger.log('successfully created Admin User');
        }
        return;
    }
    async seedTxConfig() {
        const txConfig = await this.transactionConfigRepo.find();
        const isSubscriptionMissing = !txConfig.some((item) => item.name === transactionConfig_entity_1.ETransactionConfigEnum.SUBSCRIPTION_COST);
        const isCommissionMissing = !txConfig.some((item) => item.name === transactionConfig_entity_1.ETransactionConfigEnum.REFERAL_COMMISSION);
        const isMinimalWalletMissing = !txConfig.some((item) => item.name === transactionConfig_entity_1.ETransactionConfigEnum.MINIMUM_WALLET_WITHRAWAL);
        if (isSubscriptionMissing) {
            const newSub = this.transactionConfigRepo.create({
                name: transactionConfig_entity_1.ETransactionConfigEnum.SUBSCRIPTION_COST,
                amount: 0,
            });
            await this.transactionConfigRepo.save(newSub);
            this.logger.log(`${transactionConfig_entity_1.ETransactionConfigEnum.SUBSCRIPTION_COST} tx config has been created`);
        }
        if (isCommissionMissing) {
            const newCommission = this.transactionConfigRepo.create({
                name: transactionConfig_entity_1.ETransactionConfigEnum.REFERAL_COMMISSION,
                amount: 0,
            });
            await this.transactionConfigRepo.save(newCommission);
            this.logger.log(`${transactionConfig_entity_1.ETransactionConfigEnum.REFERAL_COMMISSION} tx config has been created`);
        }
        if (isMinimalWalletMissing) {
            const newMin = this.transactionConfigRepo.create({
                name: transactionConfig_entity_1.ETransactionConfigEnum.MINIMUM_WALLET_WITHRAWAL,
                amount: 0,
            });
            await this.transactionConfigRepo.save(newMin);
            this.logger.log(`${transactionConfig_entity_1.ETransactionConfigEnum.MINIMUM_WALLET_WITHRAWAL} tx config has been created`);
        }
        return;
    }
};
exports.SeederService = SeederService;
exports.SeederService = SeederService = SeederService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.Users)),
    __param(1, (0, typeorm_1.InjectRepository)(userProfile_entity_1.UserProfile)),
    __param(2, (0, typeorm_1.InjectRepository)(roles_entity_1.Role)),
    __param(3, (0, typeorm_1.InjectRepository)(transactionConfig_entity_1.TransactionConfig)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], SeederService);
//# sourceMappingURL=seeder.service.js.map