"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const roles_entity_1 = require("./roles.entity");
const typeorm_2 = require("typeorm");
let RolesService = class RolesService {
    roleRepo;
    constructor(roleRepo) {
        this.roleRepo = roleRepo;
    }
    async createRole(name) {
        const getRole = await this.roleRepo.findOne({
            where: {
                name: name,
            },
        });
        if (getRole) {
            throw new common_1.BadRequestException('Role already exists');
        }
        const newRole = this.roleRepo.create({
            name: name,
        });
        return await this.roleRepo.save(newRole);
    }
    async getRoleByName(name) {
        const role = await this.roleRepo.findOne({
            where: {
                name: name,
            },
        });
        if (!role) {
            throw new common_1.NotFoundException('Role not found');
        }
        return role;
    }
    async getAllRoles() {
        const roles = await this.roleRepo.find();
        if (roles.length === 0) {
            throw new common_1.BadRequestException('No roles found');
        }
        return roles;
    }
    async rolesById(id) {
        const role = await this.roleRepo.findOne({
            where: {
                id: id,
            },
        });
        if (!role) {
            throw new common_1.NotFoundException('Role not found');
        }
        return role;
    }
    async updateRole(role, id) {
        const getRoleById = await this.roleRepo.findOne({
            where: {
                id,
            },
        });
        if (!getRoleById) {
            throw new common_1.BadRequestException('Role not found');
        }
        const getRole = await this.roleRepo.findOne({
            where: {
                name: role,
            },
        });
        if (getRole) {
            throw new common_1.BadRequestException(`Role with ${roles_entity_1.Role} already exists`);
        }
        getRoleById.name = role;
        return await this.roleRepo.save(getRoleById);
    }
};
exports.RolesService = RolesService;
exports.RolesService = RolesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(roles_entity_1.Role)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], RolesService);
//# sourceMappingURL=roles.service.js.map