"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MpesaService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = __importDefault(require("axios"));
const moment_1 = __importDefault(require("moment"));
const nanoid_1 = require("nanoid");
let MpesaService = class MpesaService {
    MPESA_API_URL;
    MPESA_SHORTCODE;
    MPESA_PASS_KEY;
    MPESA_API_CONSUMER_KEY;
    MPESA_API_CONSUMER_SECRET;
    MPESA_CALLBACK_URL;
    MPESA_INITIATOR_NAME;
    MPESA_INITIATOR_PASSWORD;
    MPESA_BALANCE_CALLBACK;
    MPESA_WITHDRAWAL_CALLBACK;
    constructor() {
        ((this.MPESA_API_URL = process.env.MPESA_API_URL),
            (this.MPESA_SHORTCODE = process.env.MPESA_API_SHORT_CODE),
            (this.MPESA_API_CONSUMER_KEY = process.env.MPESA_API_CONSUMER_KEY),
            (this.MPESA_API_CONSUMER_SECRET =
                process.env.MPESA_API_CONSUMER_SECRET),
            (this.MPESA_PASS_KEY = process.env.MPESA_API_PASS_KEY));
        ((this.MPESA_CALLBACK_URL = process.env.MPESA_API_STK_CALLBACK_URL),
            (this.MPESA_INITIATOR_NAME = process.env.MPESA_INITIATOR_NAME),
            (this.MPESA_INITIATOR_PASSWORD = process.env.MPESA_INITIATOR_PASSWORD),
            (this.MPESA_BALANCE_CALLBACK =
                process.env.MPESA_API_BALANCE_CALLBACK_URL),
            (this.MPESA_WITHDRAWAL_CALLBACK =
                process.env.MPESA_API_WITHRAWAL_CALLBACK_URL));
    }
    generatePassword() {
        const timestamp = (0, moment_1.default)().format('YYYYMMDDHHmmss');
        const pass = Buffer.from(`${this.MPESA_SHORTCODE}${this.MPESA_PASS_KEY}${timestamp}`).toString('base64');
        return { pass, timestamp };
    }
    async authoizeMpesa() {
        try {
            const auth = Buffer.from(`${this.MPESA_API_CONSUMER_KEY}:${this.MPESA_API_CONSUMER_SECRET}`).toString('base64');
            const resp = await axios_1.default.get(`${this.MPESA_API_URL}/oauth/v1/generate?grant_type=client_credentials`, { headers: { Authorization: `Basic ${auth}` } });
            return resp.data;
        }
        catch (e) {
            throw new common_1.InternalServerErrorException(e.message);
        }
    }
    async sendStkPush(phone_number, amount) {
        try {
            const { pass, timestamp } = this.generatePassword();
            const reqData = {
                BusinessShortCode: Number(this.MPESA_SHORTCODE),
                Password: pass,
                Timestamp: timestamp,
                TransactionType: 'CustomerPayBillOnline',
                Amount: amount,
                PartyA: phone_number,
                PartyB: this.MPESA_SHORTCODE,
                PhoneNumber: phone_number,
                CallBackURL: this.MPESA_CALLBACK_URL,
                AccountReference: 'MNETI',
                TransactionDesc: 'MNETI_DESC',
            };
            const auth = await this.authoizeMpesa();
            const res = await axios_1.default.post(`${this.MPESA_API_URL}/mpesa/stkpush/v1/processrequest`, reqData, {
                headers: {
                    Authorization: `Bearer ${auth.access_token}`,
                },
            });
            return res.data;
        }
        catch (e) {
            throw new common_1.InternalServerErrorException(e.response.data.message);
        }
    }
    async checkBalance() {
        try {
            const reqData = {
                Initiator: this.MPESA_INITIATOR_NAME,
                SecurityCredential: this.MPESA_INITIATOR_PASSWORD,
                CommandID: 'AccountBalance',
                PartyA: this.MPESA_SHORTCODE,
                IdentifierType: '4',
                Remarks: 'OK',
                QueueTimeOutURL: this.MPESA_BALANCE_CALLBACK,
                ResultURL: this.MPESA_BALANCE_CALLBACK,
            };
            const auth = await this.authoizeMpesa();
            const res = await axios_1.default.post(`${this.MPESA_API_URL}/mpesa/accountbalance/v1/query`, reqData, {
                headers: {
                    Authorization: `Bearer ${auth.access_token}`,
                },
            });
            return res.data;
        }
        catch (e) {
            console.log(e.response);
            throw new common_1.InternalServerErrorException(e.response.data);
        }
    }
    async withdraw(amount, phone_number) {
        try {
            const newReq = {
                Amount: amount,
                CommandID: 'BusinessPayment',
                InitiatorName: this.MPESA_INITIATOR_NAME,
                SecurityCredential: this.MPESA_INITIATOR_PASSWORD,
                OriginatorConversationID: (0, nanoid_1.nanoid)(12),
                PartyA: this.MPESA_SHORTCODE,
                PartyB: phone_number,
                QueueTimeOutURL: this.MPESA_WITHDRAWAL_CALLBACK,
                ResultURL: this.MPESA_WITHDRAWAL_CALLBACK,
                Remarks: 'Payment',
                Occassion: 'Payment',
            };
            const auth = await this.authoizeMpesa();
            const res = await axios_1.default.post(`${this.MPESA_API_URL}/mpesa/b2c/v3/paymentrequest`, newReq, {
                headers: {
                    Authorization: `Bearer ${auth.access_token}`,
                },
            });
            return res.data;
        }
        catch (e) {
            throw new common_1.InternalServerErrorException(e.response.data);
        }
    }
};
exports.MpesaService = MpesaService;
exports.MpesaService = MpesaService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], MpesaService);
//# sourceMappingURL=mpesa.service.js.map