"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MpesaController = void 0;
const common_1 = require("@nestjs/common");
const mpesa_service_1 = require("./mpesa.service");
const index_guards_1 = require("../auth/guards/index.guards");
const roles_guards_1 = require("../auth/guards/roles.guards");
const roles_decorator_1 = require("../common/decorators/roles.decorator");
const roles_entity_1 = require("../roles/roles.entity");
const swagger_1 = require("@nestjs/swagger");
let MpesaController = class MpesaController {
    mpesaService;
    constructor(mpesaService) {
        this.mpesaService = mpesaService;
    }
    async authMpesa() {
        return await this.mpesaService.authoizeMpesa();
    }
    async sendStkPush(req) {
        console.log(req);
        return await this.mpesaService.sendStkPush(req.phoneNumber, req.amount);
    }
    async checkBalance() {
        return await this.mpesaService.checkBalance();
    }
    async payment(req) {
        return await this.mpesaService.withdraw(req.amount, req.phoneNumber);
    }
};
exports.MpesaController = MpesaController;
__decorate([
    (0, common_1.Get)('/auth'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MpesaController.prototype, "authMpesa", null);
__decorate([
    (0, common_1.Post)('/stkpush'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MpesaController.prototype, "sendStkPush", null);
__decorate([
    (0, common_1.Get)('/balance'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MpesaController.prototype, "checkBalance", null);
__decorate([
    (0, common_1.Post)('/payment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MpesaController.prototype, "payment", null);
exports.MpesaController = MpesaController = __decorate([
    (0, common_1.Controller)('mpesa'),
    (0, common_1.UseGuards)(index_guards_1.accessTokenGuard, roles_guards_1.RolesGuard),
    (0, roles_decorator_1.Roles)(roles_entity_1.RolesEnum.ADMIN),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [mpesa_service_1.MpesaService])
], MpesaController);
//# sourceMappingURL=mpesa.controller.js.map