"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TxConfigResponseDto = exports.TxConfigRequestDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const transactionConfig_entity_1 = require("../transaction-config/transactionConfig.entity");
class TxConfigRequestDto {
    amount;
}
exports.TxConfigRequestDto = TxConfigRequestDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The amount for the transaction configuration',
        example: 100,
        minimum: 0,
    }),
    (0, class_validator_1.Min)(0, { message: 'Amount must be at least 0' }),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], TxConfigRequestDto.prototype, "amount", void 0);
class TxConfigResponseDto {
    id;
    name;
    amount;
    createdAt;
    updatedAt;
}
exports.TxConfigResponseDto = TxConfigResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unique identifier of the transaction configuration',
        example: 'c56a4180-65aa-42ec-a945-5fd21dec0538',
    }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], TxConfigResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The type of transaction configuration',
        enum: transactionConfig_entity_1.ETransactionConfigEnum,
        example: transactionConfig_entity_1.ETransactionConfigEnum.SUBSCRIPTION_COST,
    }),
    (0, class_validator_1.IsEnum)(transactionConfig_entity_1.ETransactionConfigEnum, {
        message: 'Invalid transaction config type',
    }),
    __metadata("design:type", String)
], TxConfigResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The amount for this transaction configuration',
        example: 100,
        minimum: 0,
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0, { message: 'Amount must be at least 0' }),
    __metadata("design:type", Number)
], TxConfigResponseDto.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Creation timestamp',
        example: '2025-12-08T12:34:56.789Z',
    }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Date)
], TxConfigResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Last update timestamp',
        example: '2025-12-08T12:34:56.789Z',
    }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Date)
], TxConfigResponseDto.prototype, "updatedAt", void 0);
//# sourceMappingURL=txConfig.dto.js.map