"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateWithdrawalDto = exports.CreateTransactionDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
class CreateTransactionDto {
    phoneNumber;
    userProfileId;
}
exports.CreateTransactionDto = CreateTransactionDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Phone number of the user (Kenyan format)',
        example: '254712345678',
    }),
    (0, class_validator_1.Matches)(/^(?:\+254|254|0)/, {
        message: 'Phone number must be a valid Kenyan number (e.g., 2547xxxxxxxx)',
    }),
    __metadata("design:type", String)
], CreateTransactionDto.prototype, "phoneNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User profile identifier',
        example: 'f3c1b4e8-9d2c-4bd9-a6ed-723f1d89c1bb',
    }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateTransactionDto.prototype, "userProfileId", void 0);
class CreateWithdrawalDto extends CreateTransactionDto {
    amount;
}
exports.CreateWithdrawalDto = CreateWithdrawalDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Amount to withdraw',
        example: 1000,
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(1, { message: 'Amount must be at least 1' }),
    __metadata("design:type", Number)
], CreateWithdrawalDto.prototype, "amount", void 0);
//# sourceMappingURL=transactions.dto.js.map