export interface IOAuthResponseDto {
    access_token: string;
    expires_in: number;
}
export interface IMpesaStkRequest {
    BusinessShortCode: number;
    Password: string;
    Timestamp: string;
    TransactionType: string;
    Amount: string | number;
    PartyA: string;
    PartyB: string;
    PhoneNumber: string;
    CallBackURL: string;
    AccountReference: string;
    TransactionDesc: string;
}
export interface IStkPushResponse {
    MerchantRequestID: string;
    CheckoutRequestID: string;
    ResponseCode: string;
    ResponseDescription: string;
    CustomerMessage: string;
}
export interface IMpesaAccountBalanceSyncResponse {
    OriginatorConversationID: string;
    ConversationID: string;
    ResponseCode: string;
    ResponseDescription: string;
}
export interface IMpesaSTKCallback {
    Body: {
        stkCallback: {
            MerchantRequestID: string;
            CheckoutRequestID: string;
            ResultCode: number;
            ResultDesc: string;
            CallbackMetadata: {
                Item: Array<{
                    Name: 'Amount' | 'MpesaReceiptNumber' | 'TransactionDate' | 'PhoneNumber' | string;
                    Value: number | string;
                }>;
            };
        };
    };
}
export interface IMpesaAccountBalanceRequest {
    Initiator: string;
    SecurityCredential: string;
    CommandID: string;
    PartyA: string | number;
    IdentifierType: string | number;
    Remarks: string;
    QueueTimeOutURL: string;
    ResultURL: string;
}
export interface IMpesaAccountBalanceCallback {
    Result: {
        ResultType: string;
        ResultCode: number;
        ResultDesc: string;
        OriginatorConversationID: string;
        ConversationID: string;
        TransactionID: string;
        ResultParameters?: {
            ResultParameter: Array<{
                Key: string;
                Value: string | number;
            }>;
        };
        ReferenceData?: {
            ReferenceItem: {
                Key: string;
                Value: string;
            };
        };
    };
}
export interface IMpesaWithdrawalRequest {
    OriginatorConversationID: string;
    InitiatorName: string;
    SecurityCredential: string;
    CommandID: "BusinessPayment" | string;
    Amount: string | number;
    PartyA: string;
    PartyB: string;
    Remarks: string;
    QueueTimeOutURL: string;
    ResultURL: string;
    Occassion?: string;
}
export interface IMpesaB2CResponse {
    ConversationID: string;
    OriginatorConversationID: string;
    ResponseCode: string;
    ResponseDescription: string;
}
export interface MpesaB2CCallbackResult {
    Result: {
        ResultType: number;
        ResultCode: number;
        ResultDesc: string;
        OriginatorConversationID: string;
        ConversationID: string;
        TransactionID: string;
        ReferenceData?: {
            ReferenceItem: {
                Key: string;
                Value: string;
            };
        };
    };
}
