"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefreshTokenResponseDto = exports.UserReponseDto = exports.AuthUserResponseDto = exports.RegisterUserRequestDto = exports.LoginRequestDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const match_decorator_1 = require("../common/decorators/match.decorator");
const roles_entity_1 = require("../roles/roles.entity");
const user_entity_1 = require("../users/user.entity");
const userProfile_entity_1 = require("../users/userProfile.entity");
class LoginRequestDto {
    username;
    password;
}
exports.LoginRequestDto = LoginRequestDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'john_doe or johndoe@example.com',
        description: 'User username',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], LoginRequestDto.prototype, "username", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'password123', description: 'your password' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], LoginRequestDto.prototype, "password", void 0);
class RegisterUserRequestDto {
    firstName;
    lastName;
    email;
    phone_number;
    date_of_birth;
    referredByCode;
    password;
    confirmPassword;
}
exports.RegisterUserRequestDto = RegisterUserRequestDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'John',
        description: 'First name of the user',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "firstName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Doe',
        description: 'Last name of the user',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "lastName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'johndoe@example.com',
        description: 'Valid user email',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '254712345678',
        description: 'User phone number',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MinLength)(10, { message: 'Please enter a valid number' }),
    (0, class_validator_1.MaxLength)(12, { message: 'Please enter a valid number' }),
    (0, class_validator_1.Matches)(/^\d+$/, { message: 'Phone number must contain numbers only' }),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "phone_number", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '1998-05-21',
        description: 'User date of birth',
        type: String,
    }),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Date)
], RegisterUserRequestDto.prototype, "date_of_birth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'ABC123EF',
        description: 'Referral code from another user',
        required: false,
    }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "referredByCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'StrongPassword123!',
        description: 'Password chosen by the user',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.MinLength)(6, { message: 'Password must be at least 6 characters' }),
    (0, class_validator_1.Matches)(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).+$/, {
        message: 'Password must contain at least one uppercase letter, one lowercase letter, and one number',
    }),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "password", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'StrongPassword123!',
        description: 'Password confirmation',
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, match_decorator_1.Match)('password', { message: 'Confirm password does not match password' }),
    __metadata("design:type", String)
], RegisterUserRequestDto.prototype, "confirmPassword", void 0);
class AuthUserResponseDto extends (0, swagger_1.OmitType)(user_entity_1.Users, [
    'password',
]) {
    id;
    username;
    profile;
    roles;
    createdAt;
    updatedAt;
    accessToken;
}
exports.AuthUserResponseDto = AuthUserResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'djfkeri384fijoearf', description: 'Unique user ID' }),
    __metadata("design:type", String)
], AuthUserResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'john_doe', description: 'Unique username' }),
    __metadata("design:type", String)
], AuthUserResponseDto.prototype, "username", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: () => userProfile_entity_1.UserProfile,
        required: false,
        description: 'User profile details',
    }),
    __metadata("design:type", userProfile_entity_1.UserProfile)
], AuthUserResponseDto.prototype, "profile", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: () => [roles_entity_1.Role],
        description: 'Roles assigned to the user',
    }),
    __metadata("design:type", Array)
], AuthUserResponseDto.prototype, "roles", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2025-01-25T14:48:00.000Z',
        description: 'Date when user was created',
    }),
    __metadata("design:type", Date)
], AuthUserResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2025-01-26T14:48:00.000Z',
        description: 'Date when user was last updated',
    }),
    __metadata("design:type", Date)
], AuthUserResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...',
        description: 'JWT access token for authentication',
    }),
    __metadata("design:type", String)
], AuthUserResponseDto.prototype, "accessToken", void 0);
class UserReponseDto {
    id;
    username;
    profile;
    roles;
    createdAt;
    updatedAt;
}
exports.UserReponseDto = UserReponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'djfkeri384fijoearf', description: 'Unique user ID' }),
    __metadata("design:type", String)
], UserReponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'john_doe', description: 'Unique username' }),
    __metadata("design:type", String)
], UserReponseDto.prototype, "username", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: () => userProfile_entity_1.UserProfile,
        required: false,
        description: 'User profile details',
    }),
    __metadata("design:type", userProfile_entity_1.UserProfile)
], UserReponseDto.prototype, "profile", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: () => [roles_entity_1.Role],
        description: 'Roles assigned to the user',
    }),
    __metadata("design:type", Array)
], UserReponseDto.prototype, "roles", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2025-01-25T14:48:00.000Z',
        description: 'Date when user was created',
    }),
    __metadata("design:type", Date)
], UserReponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2025-01-26T14:48:00.000Z',
        description: 'Date when user was last updated',
    }),
    __metadata("design:type", Date)
], UserReponseDto.prototype, "updatedAt", void 0);
class RefreshTokenResponseDto {
    accessToken;
}
exports.RefreshTokenResponseDto = RefreshTokenResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...',
        description: 'JWT access token for authentication',
    }),
    __metadata("design:type", String)
], RefreshTokenResponseDto.prototype, "accessToken", void 0);
//# sourceMappingURL=auth.dto.js.map