"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefershTokenStrategy = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const passport_jwt_1 = require("passport-jwt");
let RefershTokenStrategy = class RefershTokenStrategy extends (0, passport_1.PassportStrategy)(passport_jwt_1.Strategy, 'refToken') {
    constructor() {
        super({
            jwtFromRequest: passport_jwt_1.ExtractJwt.fromExtractors([
                (req) => {
                    if (!req || !req.cookies) {
                        return null;
                    }
                    const refreshTokenKey = process.env.REFRESH_TOKEN_KEY;
                    if (!refreshTokenKey)
                        return null;
                    return req.cookies[refreshTokenKey];
                },
            ]),
            ignoreExpiration: false,
            secretOrKey: process.env.REFRESH_TOKEN_SECRET,
        });
    }
    validate(payload) {
        if (!payload.sub) {
            throw new common_1.UnauthorizedException('Please login first');
        }
        return payload;
    }
};
exports.RefershTokenStrategy = RefershTokenStrategy;
exports.RefershTokenStrategy = RefershTokenStrategy = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], RefershTokenStrategy);
//# sourceMappingURL=refreshToken.strategy.js.map