"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../users/user.entity");
const users_service_1 = require("../users/users.service");
const typeorm_2 = require("typeorm");
const bcrypt_1 = require("bcrypt");
let AuthService = class AuthService {
    userService;
    jwtService;
    userRepo;
    constructor(userService, jwtService, userRepo) {
        this.userService = userService;
        this.jwtService = jwtService;
        this.userRepo = userRepo;
    }
    async signJwtToken(username, id, roles, secret, expiry) {
        return await this.jwtService.signAsync({ username: username, sub: id, roles: roles }, {
            secret: secret,
            expiresIn: Number(expiry),
        });
    }
    async signAccessToken(username, id, roles) {
        return await this.signJwtToken(username, id, roles, process.env.ACCESS_TOKEN_SECRET, process.env.ACCESS_TOKEN_EXPIRY);
    }
    async signRefreshToken(username, id, roles) {
        return await this.signJwtToken(username, id, roles, process.env.REFRESH_TOKEN_SECRET, process.env.REFRESH_TOKEN_EXPIRY);
    }
    setCookie(res, refresherToken) {
        res.cookie(process.env.REFRESH_TOKEN_KEY, refresherToken, {
            httpOnly: true,
            secure: process.env.NODE_ENV === 'production',
            sameSite: process.env.NODE_ENV === 'production' ? 'none' : 'lax',
            maxAge: Number(process.env.REFRESH_TOKEN_EXPIRY) * 1000,
            path: '/',
        });
    }
    async validateUser(username, password) {
        const user = await this.userRepo
            .createQueryBuilder('user')
            .addSelect('user.password')
            .where('user.username=:username', { username })
            .leftJoinAndSelect('user.roles', 'roles')
            .leftJoinAndSelect('user.profile', 'profile')
            .getOne();
        if (!user) {
            throw new common_1.UnauthorizedException('User is not registered yet!');
        }
        const isPasswordValid = await (0, bcrypt_1.compare)(password, user.password);
        if (!isPasswordValid) {
            return;
        }
        return user;
    }
    omitPassword(user) {
        const { password, ...rest } = user;
        return rest;
    }
    async login(user, res) {
        const accessToken = await this.signAccessToken(user.username, user.id, user.roles.map((role) => role.name));
        const refresherToken = await this.signRefreshToken(user.username, user.id, user.roles.map((role) => role.name));
        this.setCookie(res, refresherToken);
        return { ...this.omitPassword(user), accessToken };
    }
    async registerUser(user, res) {
        const newUser = await this.userService.createUserWithProfile(user);
        const [accessToken, refreshToken] = await Promise.all([
            this.signAccessToken(newUser.username, newUser.id, newUser.roles.map((role) => role.name)),
            this.signRefreshToken(newUser.username, newUser.id, newUser.roles.map((role) => role.name)),
        ]);
        this.setCookie(res, refreshToken);
        return { ...this.omitPassword(newUser), accessToken };
    }
    async refreshToken(user) {
        const token = await this.signAccessToken(user.user.username, user.user.sub, user.user.roles);
        return { accessToken: token };
    }
    async logout(res) {
        res.clearCookie(process.env.REFRESH_TOKEN_KEY);
        return;
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(2, (0, typeorm_1.InjectRepository)(user_entity_1.Users)),
    __metadata("design:paramtypes", [users_service_1.UsersService,
        jwt_1.JwtService,
        typeorm_2.Repository])
], AuthService);
//# sourceMappingURL=auth.service.js.map