import { JwtService } from '@nestjs/jwt';
import { Users } from 'src/users/user.entity';
import { UsersService } from 'src/users/users.service';
import { Repository } from 'typeorm';
import { ICreateUserInterface, IRequestWithJwtPayload, TUsersWithNoPassword } from 'src/common/interfaces/IUserInterface';
import { Response } from 'express';
import { RefreshTokenResponseDto, AuthUserResponseDto } from 'src/dtos/auth.dto';
export declare class AuthService {
    private readonly userService;
    private readonly jwtService;
    private readonly userRepo;
    constructor(userService: UsersService, jwtService: JwtService, userRepo: Repository<Users>);
    private signJwtToken;
    private signAccessToken;
    private signRefreshToken;
    private setCookie;
    validateUser(username: string, password: string): Promise<TUsersWithNoPassword | void>;
    private omitPassword;
    login(user: TUsersWithNoPassword, res: Response): Promise<AuthUserResponseDto>;
    registerUser(user: ICreateUserInterface, res: Response): Promise<AuthUserResponseDto>;
    refreshToken(user: IRequestWithJwtPayload): Promise<RefreshTokenResponseDto>;
    logout(res: Response): Promise<void>;
}
