"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthModule = void 0;
const common_1 = require("@nestjs/common");
const auth_service_1 = require("./auth.service");
const local_strategy_1 = require("./strategy/local.strategy");
const auth_controller_1 = require("./auth.controller");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../users/user.entity");
const passport_1 = require("@nestjs/passport");
const jwt_1 = require("@nestjs/jwt");
const accessToken_strategy_1 = require("./strategy/accessToken.strategy");
const refreshToken_strategy_1 = require("./strategy/refreshToken.strategy");
const roles_guards_1 = require("./guards/roles.guards");
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            passport_1.PassportModule,
            jwt_1.JwtModule.register({}),
            typeorm_1.TypeOrmModule.forFeature([user_entity_1.Users]),
        ],
        providers: [auth_service_1.AuthService, local_strategy_1.LocalStrategy, accessToken_strategy_1.AccessTokenStrategy, refreshToken_strategy_1.RefershTokenStrategy, roles_guards_1.RolesGuard],
        controllers: [auth_controller_1.AuthController],
        exports: [accessToken_strategy_1.AccessTokenStrategy, roles_guards_1.RolesGuard],
    })
], AuthModule);
//# sourceMappingURL=auth.module.js.map