import { AuthService } from './auth.service';
import type { IRequestWithJwtPayload, IRequestWithUser } from '../common/interfaces/IUserInterface';
import type { Response, Request } from 'express';
import { RefreshTokenResponseDto, RegisterUserRequestDto, AuthUserResponseDto } from 'src/dtos/auth.dto';
export declare class AuthController {
    private readonly authService;
    constructor(authService: AuthService);
    login(req: IRequestWithUser, res: Response): Promise<AuthUserResponseDto>;
    registerUser(body: RegisterUserRequestDto, res: Response): Promise<AuthUserResponseDto>;
    refreshToken(req: IRequestWithJwtPayload): Promise<RefreshTokenResponseDto>;
    logout(request: Request, res: Response): Promise<void>;
}
