"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const config_1 = require("@nestjs/config");
const users_module_1 = require("./users/users.module");
const roles_module_1 = require("./roles/roles.module");
const transactions_module_1 = require("./transactions/transactions.module");
const transaction_config_module_1 = require("./transaction-config/transaction-config.module");
const wallet_module_1 = require("./wallet/wallet.module");
const database_module_1 = require("./database/database.module");
const seeder_module_1 = require("./seeder/seeder.module");
const auth_module_1 = require("./auth/auth.module");
const mail_module_1 = require("./mail/mail.module");
const mpesa_module_1 = require("./mpesa/mpesa.module");
const redis_module_1 = require("./redis/redis.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                isGlobal: true,
                envFilePath: '.env',
            }),
            users_module_1.UsersModule,
            roles_module_1.RolesModule,
            transactions_module_1.TransactionsModule,
            transaction_config_module_1.TransactionConfigModule,
            wallet_module_1.WalletModule,
            database_module_1.DatabaseModule,
            seeder_module_1.SeederModule,
            auth_module_1.AuthModule,
            mail_module_1.MailModule,
            mpesa_module_1.MpesaModule,
            redis_module_1.RedisModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map